Attribute VB_Name = "mListviewCalls"
Option Explicit
'
' Brad Martinez  http://www.mvps.org/ccrp
'
' ===================================================
' menu defs

Private Const WM_COMMAND = &H111

' Saw these being sent to Explorer's SHELLDLL_DefView when the
' respective menu command was selected. Tried them, and they worked...
Public Const IDM_SHVIEW_LARGEICON = &H7029   ' 28713
Public Const IDM_SHVIEW_SMALLICON = &H702A   ' 28714
Public Const IDM_SHVIEW_LIST = &H702B                ' 28715
Public Const IDM_SHVIEW_REPORT = &H702C         ' 28716
Public Const IDM_SHVIEW_THUMBNAIL = &H7031   ' 28721

' ===================================================
' window classnames

' WebBrowser control
Public Const WC_WEBBROWSER = "Shell Embedding"
' WebBrowser's child window when viewing the shell
Public Const WC_SHVIEW = "SHELLDLL_DefView"
' WebBrowser's grandchild listview window
Public Const WC_LISTVIEW = "SysListView32"
' In thumbnail view, is a child of WC_SHVIEW which contains
' a 2nd listview, and is a sibling of the 1st listview (see "_todo.txt")
Public Const WC_THUMBVIEW = "ThumbnailVwExtWnd32"
' WebBrowser's child window when viewing web pages
Public Const WC_WEBVIEW = "Shell DocObject View"

' ===================================================
' listview

Public Enum LVViewStyles
  LVS_ICON = &H0
  LVS_REPORT = &H1
  LVS_SMALLICON = &H2
  LVS_LIST = &H3
  LVS_TYPEMASK = &H3
End Enum

Public Enum LVMessages
  LVM_FIRST = &H1000
  LVM_GETNEXTITEM = (LVM_FIRST + 12)
  LVM_HITTEST = (LVM_FIRST + 18)
  LVM_SETITEMSTATE = (LVM_FIRST + 43)
  LVM_GETITEMTEXT = (LVM_FIRST + 45)
End Enum

' LVM_GETNEXTITEM flags
Public Enum LVNI_Flags
  LVNI_ALL = &H0
  LVNI_FOCUSED = &H1
  LVNI_SELECTED = &H2
  LVNI_CUT = &H4
  LVNI_DROPHILITED = &H8
 
'  LVNI_ABOVE = &H100
'  LVNI_BELOW = &H200
'  LVNI_TOLEFT = &H400
'  LVNI_TORIGHT = &H800
End Enum

Public Enum LVItemStates
  LVIS_FOCUSED = &H1
  LVIS_SELECTED = &H2
End Enum
 
Public Type LVITEM   ' was LV_ITEM
  mask As Long   ' LVItemStates
  iItem As Long
  iSubItem As Long
  state As Long   ' LVItemStates
  stateMask As Long
  pszText As Long  ' must be pre-allocated
  cchTextMax As Long
  iImage As Long
  lParam As Long
#If (WIN32_IE >= &H300) Then
  iIndent As Long
#End If
End Type

Public Enum LVHITTESTINFO_flags
  LVHT_NOWHERE = &H1   ' in LV client area, but not over item
  LVHT_ONITEMICON = &H2
  LVHT_ONITEMLABEL = &H4
  LVHT_ONITEMSTATEICON = &H8
  LVHT_ONITEM = (LVHT_ONITEMICON Or LVHT_ONITEMLABEL Or LVHT_ONITEMSTATEICON)
 
'  ' outside the LV's client area
'  LVHT_ABOVE = &H8
'  LVHT_BELOW = &H10
'  LVHT_TORIGHT = &H20
'  LVHT_TOLEFT = &H40
End Enum

Public Type LVHITTESTINFO   ' was LV_HITTESTINFO
  pt As POINTAPI
  Flags As LVHITTESTINFO_flags
  iItem As Long
#If (WIN32_IE >= &H300) Then
  iSubItem As Long    ' this is was NOT in win95.  valid only for LVM_SUBITEMHITTEST
#End If
End Type
'

' Handles processing of certain messages sent to the WebBrowser's listview:
' WM_CONTEXTMENU, WM_KEYDOWN/vbKeyReturn, WM_LBUTTONDBLCLK

Public Static Function DoLVMessage(objEV As ExplorerView, _
                                                            hwndLV As Long, _
                                                            iItem As Long, _
                                                            uMsg As Long) As Long
  Dim sItem As String
  Dim lpszItem As Long
  Dim fldParent As CCRPFolderTV6.Folder
  Dim isfParent As IShellFolder
  Dim pidlRel As Long
  Dim ulAttrs As Long
  
  ' A listview item was double-clicked, get it's displayname.
  sItem = String$(MAX_PATH, 0)
  lpszItem = StrPtr(sItem)   ' StrPtr() works fine on all nulls
  Call ListView_GetItemText(hwndLV, iItem, 0, lpszItem, MAX_PATH)
  sItem = GetStrFromPtrA(lpszItem)
  If Len(sItem) = 0 Then Exit Function
  
  ' Get the FolderTreeview's selected Folder and it's
  ' IShellFolder (we have to cast from the IUnknown)
  Set fldParent = objEV.FolderTreeview.SelectedFolder
  Set isfParent = fldParent.isfMe
  
  ' Get the listview item's relative pidl.
  pidlRel = GetPIDLFromDisplayName(GetTopLevelParent(hwndLV), isfParent, sItem)
  If pidlRel Then
    
    ' Get the double-clicked listview item's attributes and see if it's a folder.
    ulAttrs = SFGAO_FOLDER
    Call isfParent.GetAttributesOf(1, pidlRel, ulAttrs)
    If (ulAttrs And SFGAO_FOLDER) Then
    
      ' Its a folder...
      Select Case uMsg
        
        Case WM_CONTEXTMENU
          ' Right-clcik, load the EV's variable with the selected folder's name.
          ' This variable will be checked in SHViewWndProc proc on a
          ' subsequent WM_INITMENUPOPUP and WM_MENUSELECTs.
          ' We'll let the message continue it's default processing by
          ' returning the implicit 0.
          objEV.RClickedLVFolder = sItem
        
        Case WM_LBUTTONDBLCLK, WM_KEYDOWN  '/vbKeyReturn
          ' Either an enter key or double click. Find and select the folder in
          ' the FTV, navigating the WebBrowser to that folder. If successful,
          ' cancel processing of the message, preventing the listview from
          ' invoking it's default "Open" context menu command.
          DoLVMessage = SelectFTVChildFolder(fldParent, sItem)
      
      End Select   ' uMsg
      
    End If   ' (ulAttrs And SFGAO_FOLDER)
    
    isMalloc.Free ByVal pidlRel
  End If   ' pidlRel

End Function

' Finds and selects the folder with the specifed SHGDN_INFOLDER displayname
' under the specifed FTV parent folder (navigating the WebBrowser to that folder).

Public Function SelectFTVChildFolder(fldParent As CCRPFolderTV6.Folder, _
                                                            sChild As String) As Boolean
  Dim fldChild As CCRPFolderTV6.Folder

  ' Expand the FolderTreeview's selected folder so
  ' it's child folders are visible and available to walk.
  fldParent.Expanded = True
  
  ' Get the selected folder's 1st child, then iterate through the
  ' selected folder's child folder's until we find the folder that
  ' matches the displayname of the double-clicked listview folder.
  Set fldChild = fldParent.Child
  
  Do While (fldChild Is Nothing) = False
    If sChild = fldChild.DisplayName Then Exit Do
    ' Get the next child folder's sibling folder
    Set fldChild = fldChild.NextSibling
  Loop
  
  If (fldChild Is Nothing) = False Then
    ' Finally, select the corresponding FTV folder.
    ' Immediately invokes a frmExplorer.FTV1_SelectionChange,
    ' which eventually calls WebBrowser1.Navigate2
    fldChild.Selected = True
    SelectFTVChildFolder = True
  End If

End Function

' If found, returns the command ID of the specified command string under
' the specifed parent menu. Command ID's are unsigned word values.

Public Function GetMenuItemIDFromStr(hmenuParent As Long, _
                                                              sTarget As String) As Long
  Dim nItems As Integer
  Dim i As Integer
  Dim sItem As String * MAX_PATH
  
  nItems = GetMenuItemCount(hmenuParent)
  For i = 0 To nItems - 1
    If GetMenuString(hmenuParent, i, sItem, MAX_PATH, MF_BYPOSITION) Then
      If sTarget = GetStrFromBufferA(sItem) Then
        GetMenuItemIDFromStr = GetMenuItemID(hmenuParent, i)
      End If
    End If
  Next

End Function

' Changes the specified listview's view style
'   hwndLV        - listview window handle
'   dwNewView - new view style to set

' Rtns True on success, False on failure

Public Function SwitchView(hwndLV As Long, dwNewView As Long) As Boolean
  Dim dwStyle As Long
    
  ' Get the current sytle
  dwStyle = GetWindowLong(hwndLV, GWL_STYLE)
  
  ' Only set the new view if the current view's bits are different.
  If (dwStyle And LVS_TYPEMASK) <> dwNewView Then
    SwitchView = SetWindowLong(hwndLV, GWL_STYLE, _
                                                      (dwStyle And Not LVS_TYPEMASK) Or dwNewView)
  End If

End Function

Public Sub SwitchSHView(hwndSHView As Long, dwNewView As LVViewStyles)
  Dim idCmd As Long
  
  If hwndSHView Then
    Select Case dwNewView
      Case LVS_ICON:             idCmd = IDM_SHVIEW_LARGEICON
      Case LVS_SMALLICON: idCmd = IDM_SHVIEW_SMALLICON
      Case LVS_LIST:              idCmd = IDM_SHVIEW_LIST
      Case LVS_REPORT:       idCmd = IDM_SHVIEW_REPORT
'      Case IDM_SHVIEW_THUMBNAIL: idCmd = IDM_SHVIEW_THUMBNAIL
    End Select
    Call SendMessage(hwndSHView, WM_COMMAND, idCmd, 0)
  End If
  
End Sub

' ============================================================
' listview macros defined in commctrl.h

Public Function ListView_GetNextItem(hWnd As Long, i As Long, Flags As LVNI_Flags) As Long
  ListView_GetNextItem = SendMessage(hWnd, LVM_GETNEXTITEM, i, ByVal MAKELPARAM(Flags, 0))
End Function

' Returns the index of the item that is selected and has the focus rectangle
' (user-defined)

Public Function ListView_GetSelectedItem(hwndLV As Long) As Long
  ListView_GetSelectedItem = ListView_GetNextItem(hwndLV, -1, LVNI_FOCUSED Or LVNI_SELECTED)
End Function
 
Public Function ListView_SetItemState(hwndLV As Long, i As Long, state As LVItemStates, mask As LVItemStates) As Boolean
  Dim lvi As LVITEM
  lvi.state = state
  lvi.stateMask = mask
  ListView_SetItemState = SendMessage(hwndLV, LVM_SETITEMSTATE, i, lvi)
End Function

' Selects the specified item and gives it the focus rectangle.
' does not de-select any currently selected items (user-defined).

Public Function ListView_SetSelectedItem(hwndLV As Long, i As Long, fSelect As Boolean) As Boolean
  ListView_SetSelectedItem = ListView_SetItemState(hwndLV, i, LVIS_FOCUSED Or (LVIS_SELECTED And fSelect), _
                                                                                                     LVIS_FOCUSED Or LVIS_SELECTED)
End Function
 
Public Function ListView_HitTest(hwndLV As Long, pinfo As LVHITTESTINFO) As Long
  ListView_HitTest = SendMessage(hwndLV, LVM_HITTEST, 0, pinfo)
End Function

Public Sub ListView_GetItemText(hwndLV As Long, i As Long, iSubItem As Long, _
                                                     pszText As Long, cchTextMax As Long)
  Dim lvi As LVITEM
  lvi.iSubItem = iSubItem
  lvi.cchTextMax = cchTextMax
  lvi.pszText = pszText
  Call SendMessage(hwndLV, LVM_GETITEMTEXT, i, lvi)
  pszText = lvi.pszText   ' fills pszText w/ pointer
End Sub
